package com.atlassian.diagnostics.ipd.api.meters;

import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;

/**
 * Interface representing a counter meter, which is a type of {@link IpdMeter}.
 * A counter meter is used to count occurrences or events.
 * <p>
 *     Values of the counter are always positive and can only be incremented.
 *     In external monitoring, counters can be used to calculate number of events in any time frame.
 * </p>
 *
 * @since 3.0.0
 */
public interface CounterMeter extends IpdMeter {
    String TYPE_ID = "counter";
    MeterFactory<CounterMeter> NOOP_FACTORY = new MeterFactory<>(Noop::new, TYPE_ID, "counter");

    @Override
    default String getTypeId() {
        return TYPE_ID;
    }

    default void increment() {
        increment(1L);
    }

    void increment(long value);

    class Noop extends NoopMeter implements CounterMeter {
        protected Noop(final MeterConfig meterConfig) {
            super(meterConfig);
        }

        @Override
        public void increment(final long value) {
            metricUpdated();
        }
    }
}
