package com.atlassian.diagnostics.ipd.api.jobs;

/**
 * In product Diagnostic Job which will be run by {@link IpdJobRunner}.
 * Objects of this interface have to be registered in Ipd Job Runner.
 * <pre>
 * {@code
 *     public CustomIpdJob(final IpdJobRegistry jobRegistry) {
 *         jobRegistry.register(this, "my.job.key");
 *     }
 * }
 * </pre>
 * @since 2.2.0
 */
public interface IpdJob {

    /**
     * This method is executed periodically on an IPD scheduler. You implement it to make IPD measurements on a regular basis.
     */
    void runJob() throws InterruptedException;

}
