package com.atlassian.diagnostics.ipd.api;

import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import org.slf4j.Logger;

import java.util.function.Consumer;
import java.util.function.Predicate;

/**
 * @since 2.2.0
 */
public final class IpdConstants {
    public static final String LOG_LABEL = "IPDMONITORING";
    public static final String IPD_APP_LOGGER_NAME = "ipd-monitoring";
    public static final String IPD_DATA_LOGGER_NAME = "ipd-monitoring-data-logger";
    public static final Consumer<IpdMeter> NO_OP = (ignored) -> {};
    public static final Predicate<MeterConfig> TRUE_CONFIG_PREDICATE = (ignored) -> true;
    public static final Predicate<IpdMeter> TRUE_METER_PREDICATE = (ignored) -> true;
    public static final Logger DEFAULT_DATA_LOGGER = org.slf4j.LoggerFactory.getLogger(IPD_DATA_LOGGER_NAME);

    private IpdConstants() {}
}
