package com.atlassian.diagnostics.internal.jmx;

import com.atlassian.diagnostics.Issue;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Date;

/**
 * MX Bean that exposes alert counts for a given {@link Issue} since the JVM was started
 */
public interface IssueAlertsMXBean {

    /**
     * @return the {@link Issue#getComponent() component} the issue is defined for
     */
    @Nonnull
    String getComponent();

    /**
     * @return the number of alerts for the issue since the JVM was started
     */
    long getCount();

    /**
     * @return the issue's description
     */
    @Nonnull
    String getDescription();

    /**
     * @return the timestamp of the most recent alert
     */
    @Nullable
    Date getLatestAlertTimestamp();

    /**
     * @return the issue's severity
     */
    @Nonnull
    String getSeverity();

    /**
     * Clears the {@link #getCount() count} and {@link #getLatestAlertTimestamp() latestAlertTimestamps}
     */
    void reset();
}
