package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.util.profiling.Metrics;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * Metric for a single Long value.
 *
 * @since 3.0.0
 */
 public class ValueMeterImpl extends IpdProfilingMeter implements ValueMeter {

    public static final List<String> ATTRIBUTES = ImmutableList.of("Value");

    private final Metrics.Builder micrometerMetric;

    public ValueMeterImpl(MeterConfig config) {
        super(config, ATTRIBUTES, ATTRIBUTES);
        micrometerMetric = Metrics.metric(getMeterKey().getName()).tags(profilingKey.getTags());
    }

    @Override
    public void update(long value) {
        if (isEnabled()) {
            micrometerMetric.setGauge(value);
            metricUpdated();
        }
    }

    public static MeterFactory<ValueMeter> factory() {
        return staticFactory;
    }

    private static final MeterFactory<ValueMeter> staticFactory = new MeterFactory<>(ValueMeterImpl::new, TYPE_ID,"value");
}
