package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.ipd.api.meters.StatsMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.Metrics;
import com.google.common.collect.ImmutableList;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Metric for a statistic value. Contains a number of statistical ATTRIBUTES: Min, Mean, 95thPercentile, 99thPercentile and more.
 *
 * @since 3.0.0
 */
public class StatsMeterImpl extends IpdProfilingMeter implements StatsMeter {

    public static final List<String> FULL_ATTRIBUTES = ImmutableList.of(
            "50thPercentile",
            "75thPercentile",
            "95thPercentile",
            "98thPercentile",
            "999thPercentile",
            "99thPercentile",
            "Count",
            "DurationUnit",
            "FifteenMinuteRate",
            "FiveMinuteRate",
            "Max",
            "Min",
            "Mean",
            "MeanRate",
            "OneMinuteRate",
            "RateUnit",
            "StdDev",
            "Value");

    public static final List<String> SHORT_ATTRIBUTES = ImmutableList.of(
            "99thPercentile",
            "Count",
            "Max",
            "Min",
            "Mean");

    private final MetricTimer micrometerMetric;

    protected StatsMeterImpl(MeterConfig config) {
        super(config, FULL_ATTRIBUTES, SHORT_ATTRIBUTES);
        micrometerMetric = Metrics.metric(getMeterKey().getName()).tags(profilingKey.getTags()).timer();
    }

    @Override
    public void update(final long value, final TimeUnit timeUnit) {
        if (isEnabled()) {
            micrometerMetric.update(value, timeUnit);
            metricUpdated();
        }
    }

    public static MeterFactory<StatsMeter> factory() {
        return staticFactory;
    }

    private static final MeterFactory<StatsMeter> staticFactory = new MeterFactory<>(StatsMeterImpl::new, TYPE_ID, "statistics");

}
