package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.internal.ipd.metrics.CounterMeterImpl;
import com.atlassian.diagnostics.internal.ipd.metrics.JmxCopyMeterImpl;
import com.atlassian.diagnostics.internal.ipd.metrics.StatsMeterImpl;
import com.atlassian.diagnostics.internal.ipd.metrics.ValueMeterImpl;
import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.meters.CounterMeter;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter.MBeanSupplier;
import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.JmxCopyMeter;
import com.atlassian.diagnostics.ipd.api.meters.StatsMeter;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.CustomMeterImpl;
import com.atlassian.diagnostics.ipd.api.registry.AbstractIpdMeterRegistry;

import javax.management.ObjectName;
import java.util.Map;

/**
 * IpdMainRegistry is a root registry that allows for registering new ipd metrics in the product.
 * @since 3.0.0
 */
public class IpdMeterRegistry extends AbstractIpdMeterRegistry {


    public IpdMeterRegistry(final MeterConfigurations meterConfigurations) {
        super(meterConfigurations);
    }

    protected IpdMeterRegistry(final MeterConfigurations meterConfigurations, final Map<MeterKey, IpdMeter> meters) {
        super(meterConfigurations, meters);
    }

    protected MeterConfigurations getMeterConfigurations() {
        return meterConfigurations;
    }

    protected Map<MeterKey, IpdMeter> getMetersStorage()  {
        return meters;
    }

    @Override
    public ValueMeter value(final String name, final MeterTag... tags) {
        return register(ValueMeterImpl.factory(), name, tags);
    }

    @Override
    public StatsMeter stats(final String name, final MeterTag... tags) {
        return register(StatsMeterImpl.factory(), name, tags);
    }

    @Override
    public CounterMeter counter(final String name, final MeterTag... staticTags) {
        return register(CounterMeterImpl.factory(), name, staticTags);
    }

    @Override
    public <T> CustomMeter<T> custom(final String name, final Class<T> type, final MeterTag... tags) {
        return register(CustomMeterImpl.factory(type), name, tags);
    }

    @Override
    public <T> CustomMeter<T> custom(final String name, final MBeanSupplier<T> instance, final MeterTag... tags) {
        return register(CustomMeterImpl.factory(instance), name, tags);
    }

    @Override
    public JmxCopyMeter statsCopy(final String name, final ObjectName objectToCopy, final MeterTag... tags) {
        return register(JmxCopyMeterImpl.factory(objectToCopy, StatsMeterImpl.FULL_ATTRIBUTES, StatsMeterImpl.SHORT_ATTRIBUTES), name, tags);
    }
}

