package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterConfigurationsImpl;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.diagnostics.ipd.api.registry.PluginIpdFactory;
import org.osgi.framework.BundleContext;

/**
 * Default implementation of {@link PluginIpdFactory}.
 * This factory should be exposed by the product to plugins to create their own {@link IpdRegistry} and {@link IpdJobRegistry}.
 * @since 5.0.0
 */
public class DefaultPluginIpdFactory implements PluginIpdFactory {
    protected final IpdMeterRegistry ipdRegistry;
    protected final IpdJobRegistry ipdJobRegistry;

    public DefaultPluginIpdFactory(final IpdMeterRegistry ipdRegistry, final IpdJobRegistry ipdJobRegistry) {
        this.ipdRegistry = ipdRegistry;
        this.ipdJobRegistry = ipdJobRegistry;
    }

    @Override
    public IpdRegistry createRegistry(final BundleContext bundleContext) {
        return createRegistry(new MeterConfigurationsImpl(b -> {}), bundleContext);
    }

    @Override
    public IpdRegistry createRegistry(final MeterConfigurations meterConfig, final BundleContext bundleContext) {
        final var pluginName = bundleContext.getBundle().getSymbolicName();

        return new PluginAwareIpdRegistry(pluginName, ipdRegistry, meterConfig);
    }

    @Override
    public IpdJobRegistry createJobRegistry(final BundleContext bundleContext) {
        return new PluginAwareIpdJobRegistry(ipdJobRegistry);
    }
}
