package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.internal.ipd.IpdMetricBuilder;
import com.atlassian.diagnostics.ipd.internal.spi.IpdMetric;
import com.atlassian.diagnostics.ipd.internal.spi.MetricOptions;
import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.Metrics;
import com.google.common.collect.ImmutableList;

import java.util.Arrays;
import java.util.List;

/**
 * Metric for a single Long value.
 *
 * @since 3.0.0
 */
public class IpdValueMetric extends IpdMicrometerMetric {

    public static final List<String> attributes = ImmutableList.of("Value");

    private final Metrics.Builder micrometerMetric;

    protected IpdValueMetric(MetricOptions options) {
        super(options, attributes, attributes);
        micrometerMetric = Metrics.metric(getMetricKey().getMetricName()).tags(getMetricKey().getTags());
    }

    public void update(Long value) {
        if (isEnabled()) {
            micrometerMetric.setGauge(value);
            metricUpdated();
        }
    }

    public static IpdMetricBuilder<IpdValueMetric> builder(String metricName, MetricTag.RequiredMetricTag... staticTags) {
        return new IpdMetricBuilder<>(
                appendToMetricName(metricName, "value"),
                Arrays.asList(staticTags),
                IpdValueMetric::new,
                IpdValueMetric::verifyExpectedMetricType);
    }

    private static void verifyExpectedMetricType(final IpdMetric ipdMetric) throws ClassCastException {
        if (ipdMetric instanceof IpdValueMetric) {
            return;
        }
        throw new ClassCastException(String.format("Metric type was %s, but expected %s", ipdMetric.getClass(), IpdValueMetric.class));
    }
}
