package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.internal.ipd.IpdMetricBuilder;
import com.atlassian.diagnostics.ipd.internal.spi.IpdMetric;
import com.atlassian.diagnostics.ipd.internal.spi.MetricOptions;
import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.Metrics;
import com.google.common.collect.ImmutableList;

import java.util.Arrays;
import java.util.List;

/**
 * Metric for counter value. Value of this metric should always increase.
 * @since 3.0.0
 */
public class IpdCounterMetric extends IpdMicrometerMetric {

    public static final List<String> attributes = ImmutableList.of("Count");
    private final Metrics.Builder micrometerMetric;

    protected IpdCounterMetric(final MetricOptions metricOptions) {
        super(metricOptions, attributes, attributes);
        micrometerMetric = Metrics.metric(getMetricKey().getMetricName()).tags(getMetricKey().getTags());
    }

    public void increment() {
        increment(1L);
    }

    public void increment(long value) {
        if (isEnabled()) {
            micrometerMetric.incrementCounter(value);
            metricUpdated();
        }
    }

    public static IpdMetricBuilder<IpdCounterMetric> builder(String metricName, MetricTag.RequiredMetricTag... staticTags) {
        return new IpdMetricBuilder<>(
                appendToMetricName(metricName,"counter"),
                Arrays.asList(staticTags),
                IpdCounterMetric::new,
                IpdCounterMetric::verifyExpectedMetricType);
    }

    private static void verifyExpectedMetricType(final IpdMetric ipdMetric) throws ClassCastException {
        if (ipdMetric instanceof IpdCounterMetric) {
            return;
        }
        throw new ClassCastException(String.format("Metric type was %s, but expected %s", ipdMetric.getClass(), IpdCounterMetric.class));
    }
}
