package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.ipd.internal.spi.IpdLoggingService;

import static com.atlassian.diagnostics.internal.ipd.DefaultLoggingService.getCurrentTimestamp;

public class IpdMainRegistryLogger {

    private final IpdMainRegistry ipdMainRegistry;
    private final IpdLoggingService ipdLoggingService;

    public IpdMainRegistryLogger(final IpdMainRegistry ipdMainRegistry, final IpdLoggingService ipdLoggingService) {
        this.ipdMainRegistry = ipdMainRegistry;
        this.ipdLoggingService = ipdLoggingService;
    }

    public void logRegisteredMetrics(boolean includeExtraLogging) {
        String timestamp = getCurrentTimestamp();
        ipdMainRegistry.getMetrics()
                .stream()
                .filter(metric -> metric.getOptions().isRegularLogging())
                .forEach(metric -> ipdLoggingService.logMetric(metric, timestamp, includeExtraLogging));
    }
}
