package com.atlassian.diagnostics.internal.jmx;

import javax.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;

public class ThreadMemoryAllocation {

    private final String threadName;
    private final long memoryAllocationInBytes;
    private final StackTraceElement[] stackTrace;

    public ThreadMemoryAllocation(@Nonnull final String threadName, final long memoryAllocationInBytes, @Nonnull final StackTraceElement[] stackTrace) {
        this.threadName = threadName;
        this.memoryAllocationInBytes = memoryAllocationInBytes;
        this.stackTrace = stackTrace;
    }

    @Nonnull
    public String getThreadName() {
        return threadName;
    }

    public long getMemoryAllocationInBytes() {
        return memoryAllocationInBytes;
    }

    @Nonnull
    public StackTraceElement[] getStackTrace() {
        return stackTrace;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ThreadMemoryAllocation that = (ThreadMemoryAllocation) o;
        return memoryAllocationInBytes == that.memoryAllocationInBytes &&
                Objects.equals(threadName, that.threadName) &&
                Arrays.equals(stackTrace, that.stackTrace);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(threadName, memoryAllocationInBytes);
        result = 31 * result + Arrays.hashCode(stackTrace);
        return result;
    }
}
