package com.atlassian.diagnostics.internal.ipd.metrics.wrapper;

import com.atlassian.diagnostics.internal.ipd.metrics.IpdStatsMetric;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdValueMetric;

/**
 * Wraps {@link IpdValueMetric} and {@link IpdStatsMetric} into one class allowing updating both of them in one operation.
 * @since 3.0.0
 */
public class IpdValueAndStatsMetricWrapper {

    private final IpdStatsMetric ipdStatsMetric;
    private final IpdValueMetric ipdValueMetric;

    public IpdValueAndStatsMetricWrapper(IpdStatsMetric ipdStatsMetric, IpdValueMetric ipdValueMetric) {
        this.ipdValueMetric = ipdValueMetric;
        this.ipdStatsMetric = ipdStatsMetric;
    }

    /**
     * Updates {@link IpdValueMetric} and {@link IpdStatsMetric} with value.
     * @param value value with which the metrics will be updated.
     */
    public void update(Long value) {
        ipdStatsMetric.update(value);
        ipdValueMetric.update(value);
    }

    /**
     * Updates {@link IpdValueMetric} with value.
     * @param value value with which the metric will be updated.
     */
    public void updateValue(Long value) {
        ipdValueMetric.update(value);
    }

    /**
     * Updates {@link IpdStatsMetric} with value.
     * @param value value with which the metric will be updated.
     */
    public void updateStats(Long value) {
        ipdStatsMetric.update(value);
    }
}
