package com.atlassian.diagnostics.internal.util;

import java.time.Instant;

public class InstantPrecisionUtil {
    private InstantPrecisionUtil() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is a utility class, can't be instantiated");
    }

    /**
     * The Java 11 JVM offers nanosecond precision if the hardware supports it and this breaks a lot of assumptions
     * within the diagnostics framework that a long would hold enough milliseconds since epoch precision that it's the
     * same as an Instance object.
     *
     * @param instant the instant to truncate
     * @return a new instant with truncated nanosecond level precision
     */
    public static Instant truncateNanoSecondPrecision(final Instant instant) {
        return Instant.ofEpochMilli(instant.toEpochMilli());
    }
}
