package com.atlassian.diagnostics.internal.jmx;

import javax.annotation.Nullable;
import java.util.Date;

/**
 * MX Bean that exposes alert counts, broken down by severity since the JVM was started
 */
public interface AlertsMXBean {

    /**
     * @return the number of alerts of severity ERROR since the JVM was started
     */
    long getErrorCount();

    /**
     * @return the number of alerts of severity INFO since the JVM was started
     */
    long getInfoCount();

    /**
     * @return the timestamp of the most recent alert
     */
    @Nullable
    Date getLatestAlertTimestamp();

    /**
     * @return the total number of alerts since the JVM was started
     */
    long getTotalCount();

    /**
     * @return the number of alerts of severity WARNING since the JVM was started
     */
    long getWarningCount();

    /**
     * Clears the {@link #getInfoCount() info}, {@link #getWarningCount()} and {@link #getErrorCount() error} counts and
     * the {@link #getLatestAlertTimestamp() latestAlertTimestamps}
     */
    void reset();
}
