package com.atlassian.diagnostics.internal.dao;

import javax.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

public class SimpleMinimalAlertEntity implements MinimalAlertEntity {

    private final int detailsLength;
    private final long id;
    private final String issueId;
    private final String nodeName;
    private final Instant timestamp;
    private final String triggerPluginKey;

    public SimpleMinimalAlertEntity(long id, long timestamp, String issueId, String triggerPluginKey,
                                    String nodeName, int detailsLength) {
        this.detailsLength = detailsLength;
        this.id = id;
        this.issueId = requireNonNull(issueId, "issueId");
        this.nodeName = requireNonNull(nodeName, "nodeName");
        this.timestamp = Instant.ofEpochMilli(timestamp);
        this.triggerPluginKey = requireNonNull(triggerPluginKey, "pluginKey");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SimpleMinimalAlertEntity that = (SimpleMinimalAlertEntity) o;
        return this.detailsLength == that.detailsLength &&
                this.id == that.id &&
                Objects.equals(this.issueId, that.issueId) &&
                Objects.equals(this.nodeName, that.nodeName) &&
                Objects.equals(this.triggerPluginKey, that.triggerPluginKey) &&
                Objects.equals(this.timestamp, that.timestamp);
    }

    @Override
    public int getDetailsJsonLength() {
        return this.detailsLength;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Nonnull
    @Override
    public String getIssueId() {
        return this.issueId;
    }

    @Nonnull
    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Nonnull
    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    @Override
    public String getTriggerPluginKey() {
        return this.triggerPluginKey;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.detailsLength, this.id, this.issueId, this.nodeName, this.triggerPluginKey, this.timestamp);
    }
}
