package com.atlassian.diagnostics.internal.dao;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.Severity;

import javax.annotation.Nonnull;
import java.time.Instant;

public class SimpleAlertEntity implements AlertEntity {

    private final String detailsJson;
    private final long id;
    private final String issueId;
    private final String issueComponentId;
    private final Severity issueSeverity;
    private final String nodeName;
    private final Instant timestamp;
    private final String triggerModule;
    private final String triggerPluginKey;
    private final String triggerPluginVersion;

    public SimpleAlertEntity(Alert alert) {
        this(alert, alert.getId());
    }

    public SimpleAlertEntity(Alert alert, long id) {
        this.id = id;

        Issue issue = alert.getIssue();
        String json;
        try {
            json = alert.getDetails().map(details -> issue.getJsonMapper().toJson(details)).orElse(null);
        } catch (Exception e) {
            json = null;
        }
        this.detailsJson = json;
        this.issueId = issue.getId();
        this.issueComponentId = issue.getComponent().getId();
        this.issueSeverity = issue.getSeverity();
        this.nodeName = alert.getNodeName();
        this.timestamp = alert.getTimestamp();
        AlertTrigger trigger = alert.getTrigger();
        this.triggerModule = trigger.getModule().orElse(null);
        this.triggerPluginKey = trigger.getPluginKey();
        this.triggerPluginVersion = trigger.getPluginVersion().orElse(null);
    }

    @Override
    public String getDetailsJson() {
        return this.detailsJson;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Nonnull
    @Override
    public String getIssueId() {
        return this.issueId;
    }

    @Nonnull
    @Override
    public String getIssueComponentId() {
        return this.issueComponentId;
    }

    @Nonnull
    @Override
    public Severity getIssueSeverity() {
        return this.issueSeverity;
    }

    @Nonnull
    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Nonnull
    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTriggerModule() {
        return this.triggerModule;
    }

    @Nonnull
    @Override
    public String getTriggerPluginKey() {
        return this.triggerPluginKey;
    }

    @Override
    public String getTriggerPluginVersion() {
        return this.triggerPluginVersion;
    }
}
