package com.atlassian.diagnostics.internal.analytics;

import com.google.common.hash.Hashing;

import java.nio.charset.StandardCharsets;

public class AnalyticsUtils {


    /**
     * Calculates a cryptographic hash for the provided value and returns the first 16 bytes of the hash in UUID
     * format. This is useful for analytics because UUID values are always allowed by the analytics framework. Encoding
     * a value as a UUID give us a consistent mapping for a value, without disclosing the actual value.
     *
     * @param value the value to encode
     * @return a UUID representation of the hashed value, or {@code null} if {@code value} was {@code null}
     */
    public static String toUuidFormat(String value) {
        if (value == null) {
            return null;
        }
        String md5 = Hashing.md5().hashString(value, StandardCharsets.UTF_8).toString();
        return md5.substring(0, 8) + '-' + md5.substring(8, 12) + "-" + md5.substring(12, 16) + "-" +
                md5.substring(16, 20) + "-" + md5.substring(20, 32);
    }
}
