package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.Interval;

import javax.annotation.Nonnull;
import java.time.Instant;

import static java.util.Objects.requireNonNull;

public class SimpleInterval implements Interval {

    private final Instant end;
    private final Instant start;

    public SimpleInterval(Instant start, Instant end) {
        this.end = requireNonNull(end, "end");
        this.start = requireNonNull(start, "start");
    }

    @Nonnull
    @Override
    public Instant getEnd() {
        return end;
    }

    @Nonnull
    @Override
    public Instant getStart() {
        return start;
    }
}
