package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.Elisions;
import com.atlassian.diagnostics.Interval;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;

public class SimpleElisions implements Elisions {

    private final int count;
    private final Interval interval;

    public SimpleElisions(@Nonnull Interval interval, int count) {
        checkArgument(count > 0, "count must be greater than 0");
        this.count = count;
        this.interval = requireNonNull(interval, "interval");
    }

    @Override
    public int getCount() {
        return count;
    }

    @Nonnull
    @Override
    public Interval getInterval() {
        return interval;
    }
}
