package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.Component;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.MoreObjects;

import javax.annotation.Nonnull;

class SimpleComponent implements Component {

    private final String nameI18nKey;
    private final I18nResolver i18nResolver;
    private final String id;

    SimpleComponent(I18nResolver i18nResolver, String id, String nameI18nKey) {
        this.i18nResolver = i18nResolver;
        this.id = id;
        this.nameI18nKey = nameI18nKey;
    }

    @Nonnull
    @Override
    public String getId() {
        return id;
    }

    @Nonnull
    @Override
    public String getName() {
        return i18nResolver.getText(nameI18nKey);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .toString();
    }
}
