package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertListener;
import com.atlassian.diagnostics.internal.dao.AlertEntityDao;
import com.atlassian.sal.api.transaction.TransactionTemplate;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class PersistingAlertListener implements AlertListener {

    private final AlertEntityDao dao;
    private final TransactionTemplate transactionTemplate;

    public PersistingAlertListener(@Nonnull AlertEntityDao dao, @Nonnull TransactionTemplate transactionTemplate) {
        this.dao = requireNonNull(dao, "dao");
        this.transactionTemplate = requireNonNull(transactionTemplate, "transactionTemplate");
    }

    @Override
    public void onAlert(@Nonnull Alert alert) {
        transactionTemplate.execute(() -> {
            dao.save(alert);
            return null;
        });
    }
}
