package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.MonitorConfiguration;

public abstract class AlertProvider<T extends MonitorConfiguration> {

    private final String key;
    protected final T monitorConfiguration;

    protected AlertProvider(final String key, final T monitorConfiguration) {
        this.key = key;
        this.monitorConfiguration = monitorConfiguration;
    }

    public boolean isEnabled() {
        return monitorConfiguration.isEnabled();
    }

    public String getKey() {
        return key;
    }
}
