package com.atlassian.diagnostics.internal.jmx;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;

public interface JmxService {

    ThreadMXBean getThreadMXBean();

    @Nonnull
    List<MemoryPoolMXBean> getMemoryPoolMXBeans();

    @Nonnull
    List<GarbageCollectorMXBean> getGarbageCollectorMXBeans();

    boolean hasObjectName(final String instanceOfQuery);

    @Nullable
    <T> T getJmxAttribute(@Nonnull final String instanceOfQuery, @Nonnull final String attributeName);

    @Nonnull
    <T> List<T> getJmxAttributes(final String instanceOfQuery, final String[] attributeNames);
}
