package com.atlassian.diagnostics.internal.dao;

import com.atlassian.diagnostics.CallbackResult;

import javax.annotation.Nonnull;

@FunctionalInterface
public interface RowCallback<T> {

    /**
     * @return {@link CallbackResult#DONE} to signal to the producer that no more elements should be produced;
     *         otherwise {@link CallbackResult#CONTINUE} to indicate if the producer has more elements to continue
     *         calling {@code onRow}
     */
    @Nonnull
    CallbackResult onRow(T rowData);
}
