package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.AlertWithElisions;
import com.atlassian.diagnostics.Elisions;
import com.atlassian.diagnostics.Issue;

import javax.annotation.Nonnull;
import java.util.Optional;

import static java.util.Optional.ofNullable;

public class SimpleAlertWithElisions extends SimpleAlert implements AlertWithElisions {

    private final Elisions elisions;

    private SimpleAlertWithElisions(Builder builder) {
        super(builder);

        this.elisions = builder.elisions;
    }

    @Nonnull
    @Override
    public Optional<Elisions> getElisions() {
        return ofNullable(elisions);
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private Elisions elisions;

        public Builder(@Nonnull Issue issue, @Nonnull String nodeName) {
            super(issue, nodeName);
        }

        @Nonnull
        @Override
        public SimpleAlertWithElisions build() {
            return new SimpleAlertWithElisions(this);
        }

        @Nonnull
        public Builder elisions(Elisions value) {
            this.elisions = value;
            return self();
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
