package com.atlassian.diagnostics.internal;

import org.osgi.framework.Bundle;

import javax.annotation.Nonnull;
import java.util.Optional;

public interface PluginHelper extends PluginDetailsSupplier {

    /**
     * @return the OSGI bundle from which the current call-site has been called, or {@link Optional#empty()} if not
     *         called from an OSGI bundle, or the bundle cannot be determined
     */
    @Nonnull
    Optional<Bundle> getCallingBundle();

    /**
     * @param pluginKey the plugin key to resolve
     * @return the name of the resolved plugin, or {@code pluginKey} if the name could not determined
     */
    @Nonnull
    String getPluginName(@Nonnull String pluginKey);

    /**
     * @param bundle the bundle, possibly {@code null}
     * @return {@code true} if the bundle is a non-bundled plugin, otherwise {@code false}
     */
    boolean isUserInstalled(Bundle bundle);
}
