package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.MonitoringService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 */
public class PlatformMonitorInitializer {

    private static final Logger log = LoggerFactory.getLogger(PlatformMonitorInitializer.class);

    public PlatformMonitorInitializer(MonitoringService monitoringService,
                                      List<InitializingMonitor> coreMonitors) {

        coreMonitors.forEach(monitor -> init(monitoringService, monitor));
    }

    private void init(MonitoringService monitoringService, InitializingMonitor monitor) {
        if (monitor != null) {
            try {
                monitor.init(monitoringService);
                log.debug("Initialized monitor '{}'", monitor.getClass().getName());
            } catch (NoClassDefFoundError | RuntimeException e) {
                log.warn("Failed to initialize monitor {}", monitor.getClass().getName(), e);
            }
        }
    }
}