package com.atlassian.diagnostics.internal.dao;

import javax.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

public class SimpleMinimalAlertEntity implements MinimalAlertEntity {

    private final int detailsLength;
    private final long id;
    private final String issueId;
    private final String nodeName;
    private final Instant timestamp;
    private final String triggerPluginKey;

    public SimpleMinimalAlertEntity(long id, long timestamp, String issueId, String triggerPluginKey,
                                    String nodeName, int detailsLength) {
        this.detailsLength = detailsLength;
        this.id = id;
        this.issueId = requireNonNull(issueId, "issueId");
        this.nodeName = requireNonNull(nodeName, "nodeName");
        this.timestamp = Instant.ofEpochMilli(timestamp);
        this.triggerPluginKey = requireNonNull(triggerPluginKey, "pluginKey");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SimpleMinimalAlertEntity that = (SimpleMinimalAlertEntity) o;
        return detailsLength == that.detailsLength &&
                id == that.id &&
                Objects.equals(issueId, that.issueId) &&
                Objects.equals(nodeName, that.nodeName) &&
                Objects.equals(triggerPluginKey, that.triggerPluginKey) &&
                Objects.equals(timestamp, that.timestamp);
    }

    @Override
    public int getDetailsJsonLength() {
        return detailsLength;
    }

    @Override
    public long getId() {
        return id;
    }

    @Nonnull
    @Override
    public String getIssueId() {
        return issueId;
    }

    @Nonnull
    @Override
    public String getNodeName() {
        return nodeName;
    }

    @Nonnull
    @Override
    public Instant getTimestamp() {
        return timestamp;
    }

    @Nonnull
    @Override
    public String getTriggerPluginKey() {
        return triggerPluginKey;
    }

    @Override
    public int hashCode() {
        return Objects.hash(detailsLength, id, issueId, nodeName, triggerPluginKey, timestamp);
    }
}
