package com.atlassian.diagnostics.internal.dao;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.Severity;

import javax.annotation.Nonnull;
import java.time.Instant;

public class SimpleAlertEntity implements AlertEntity {

    private final String detailsJson;
    private final long id;
    private final String issueId;
    private final String issueComponentId;
    private final Severity issueSeverity;
    private final String nodeName;
    private final Instant timestamp;
    private final String triggerModule;
    private final String triggerPluginKey;
    private final String triggerPluginVersion;

    public SimpleAlertEntity(Alert alert) {
        this(alert, alert.getId());
    }

    public SimpleAlertEntity(Alert alert, long id) {
        this.id = id;

        Issue issue = alert.getIssue();
        String json;
        try {
            json = alert.getDetails().map(details -> issue.getJsonMapper().toJson(details)).orElse(null);
        } catch (Exception e) {
            json = null;
        }
        detailsJson = json;
        issueId = issue.getId();
        issueComponentId = issue.getComponent().getId();
        issueSeverity = issue.getSeverity();
        nodeName = alert.getNodeName();
        timestamp = alert.getTimestamp();
        AlertTrigger trigger = alert.getTrigger();
        triggerModule = trigger.getModule().orElse(null);
        triggerPluginKey = trigger.getPluginKey();
        triggerPluginVersion = trigger.getPluginVersion().orElse(null);
    }

    @Override
    public String getDetailsJson() {
        return detailsJson;
    }

    @Override
    public long getId() {
        return id;
    }

    @Nonnull
    @Override
    public String getIssueId() {
        return issueId;
    }

    @Nonnull
    @Override
    public String getIssueComponentId() {
        return issueComponentId;
    }

    @Nonnull
    @Override
    public Severity getIssueSeverity() {
        return issueSeverity;
    }

    @Nonnull
    @Override
    public String getNodeName() {
        return nodeName;
    }

    @Nonnull
    @Override
    public Instant getTimestamp() {
        return timestamp;
    }

    @Override
    public String getTriggerModule() {
        return triggerModule;
    }

    @Nonnull
    @Override
    public String getTriggerPluginKey() {
        return triggerPluginKey;
    }

    @Override
    public String getTriggerPluginVersion() {
        return triggerPluginVersion;
    }
}
