package com.atlassian.diagnostics.internal.dao;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.DiagnosticsConstants;
import com.atlassian.diagnostics.Issue;

import javax.annotation.Nonnull;
import java.time.Instant;

public interface MinimalAlertEntity {

    /**
     * @return the length in characters of the JSON details
     */
    int getDetailsJsonLength();

    /**
     * @return the ID of the persisted entity
     */
    long getId();

    /**
     * @return the {@link Issue#getId() ID} of the alert's issue
     */
    @Nonnull
    String getIssueId();

    /**
     * @return the alert's {@link Alert#getNodeName()} node name
     */
    @Nonnull
    String getNodeName();

    /**
     * @return the alert trigger's {@link AlertTrigger#getPluginKey() plugin key},
     *         or {@link DiagnosticsConstants#PLUGIN_NOT_DETECTED_KEY} if no trigger was detected
     */
    @Nonnull
    String getTriggerPluginKey();

    /**
     * @return the alert's {@link Alert#getTimestamp()}
     */
    @Nonnull
    Instant getTimestamp();
}
