package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.AlertCount;
import com.atlassian.diagnostics.AlertCriteria;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.PageCallback;
import com.atlassian.diagnostics.PageRequest;

import javax.annotation.Nonnull;

public interface InternalMonitoringService extends MonitoringService {

    /**
     * Gives unsecured access to {@link #streamAlertCounts(AlertCriteria, PageCallback, PageRequest)}, to allow
     * publishing of daily analytics
     */
    <T> T internalStreamAlertCounts(@Nonnull AlertCriteria criteria,
                                    @Nonnull PageCallback<? super AlertCount, T> callback,
                                    @Nonnull PageRequest pageRequest);
}