package com.atlassian.diagnostics.ipd.internal.spi;

import com.atlassian.annotations.ExperimentalApi;

import javax.annotation.Nonnull;

/**
 * Job runner that runs all registered {@link IpdJob}s.
 *
 * @since 2.2.0
 */
@ExperimentalApi
public interface IpdJobRunner {

    /**
     * Register single job. Jobs are stored by class name.
     */
    void register(@Nonnull IpdJob job);

    /**
     * Runs all registered jobs synchronously.
     * @since 2.3.0
     */
    void runJobs();
}
