package com.atlassian.diagnostics;

import javax.annotation.Nonnull;

/**
 * A convenience base class for a {@link PageCallback streaming callback} that returns some possibly {@code null}
 * value of type T {@link #onEnd(PageSummary) at the end of streaming} and does no initialisation itself of this value
 * {@link #onStart(PageRequest) before the first item}.
 *
 * @param <T> the type of the value to return {@link #onEnd(PageSummary) at the end of streaming}
 */
public abstract class AbstractPageCallback<T, R> implements PageCallback<T, R> {

    protected R value;

    protected AbstractPageCallback(R value) {
        this.value = value;
    }

    @Override
    public void onStart(@Nonnull PageRequest pageRequest) {
        // ignore
    }

    @Override
    public R onEnd(@Nonnull PageSummary summary) {
        return value;
    }
}
