package com.atlassian.diagnostics.ipd.internal.spi;

import java.util.Map;

/**
 * Represents an immutable reading value for the ipd metric.
 *
 * @since 3.0.0
 */
public class IpdMetricValue {
    private final String label;
    private final String objectName;
    private final Map<String, String> tags;
    private final Map<String, Object> attributes;

    public IpdMetricValue(String label, String objectName, Map<String, String> tags, Map<String, Object> attributes) {
        this.label = label;
        this.objectName = objectName;
        this.tags = tags;
        this.attributes = attributes;
    }

    public String getLabel() {
        return label;
    }

    public String getObjectName() {
        return objectName;
    }

    public Map<String, String> getTags() {
        return tags;
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }
}

