package com.atlassian.diagnostics;

import javax.annotation.Nonnull;

/**
 * Identifies a component in the system that provides monitoring support
 */
public interface Component {

    /**
     * @return the unique ID that identifies the component, e.g. ATL-EVENT
     */
    @Nonnull
    String getId();

    /**
     * @return a human readable name that identifies the component, internationalized using i18n
     */
    @Nonnull
    String getName();
}
