package com.atlassian.diagnostics;

import javax.annotation.Nonnull;

/**
 * Listener that can be {@link MonitoringService#subscribe subscribed} to receive system {@link Alert alerts}
 */
public interface AlertListener {

    /**
     * Callback methods that is invoked when an {@link Alert alert} is raised
     * @param alert the alert
     */
    void onAlert(@Nonnull Alert alert);
}
