package com.atlassian.diagnostics;

import com.google.common.collect.Lists;

import javax.annotation.Nonnull;
import java.util.List;

import static com.atlassian.diagnostics.CallbackResult.CONTINUE;

/**
 * Utility class for creating useful and commonly-used {@link PageCallback page streaming callbacks}
 */
public class AlertCallbacks {

    private AlertCallbacks() {
    }

    /**
     * Convenience method to return a {@link PageCallback streaming callback} that collects the entire list of the
     * streamed items.
     */
    public static <T> PageCallback<T, List<T>> collectingAll() {
        return new AbstractPageCallback<T, List<T>>(Lists.newArrayList()) {
            @Nonnull
            @Override
            public CallbackResult onItem(@Nonnull T item) {
                value.add(item);
                return CONTINUE;
            }
        };
    }
}
