package com.atlassian.diagnostics.detail;

import javax.annotation.Nonnull;
import java.util.Optional;

public interface ThreadDump {

    /**
     * @return the thread ID
     */
    long getId();

    /**
     * @return the thread name
     */
    @Nonnull
    String getName();

    /**
     * @return the thread state when the thread dump was taken
     */
    @Nonnull
    Thread.State getState();

    /**
     * @return the thread stack trace as a simple string, if one was collected when the thread dump was taken
     */
    @Nonnull
    Optional<String> getStackTrace();

    /**
     * @return whether the thread is a daemon thread
     */
    boolean isDaemon();
}
