/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PluginDetails {
    private final String key;
    private final String name;
    private final String version;

    public PluginDetails(String key, String name, String version) {
        this.key = (String)MoreObjects.firstNonNull((Object)StringUtils.trimToNull((String)key), (Object)"not-detected");
        this.name = (String)MoreObjects.firstNonNull((Object)name, (Object)key);
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDetails plugin = (PluginDetails)o;
        return Objects.equal((Object)this.key, (Object)plugin.key) && Objects.equal((Object)this.version, (Object)plugin.version);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.version});
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").addValue((Object)this.key).addValue((Object)this.name).addValue((Object)this.version).toString();
    }
}

