/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devrel.util;

import java.util.Objects;

public class TextUtils {
    public static String htmlEncode(String s) {
        return TextUtils.htmlEncode(s, true);
    }

    public static String htmlEncode(String s, boolean encodeSpecialChars) {
        s = Objects.requireNonNull(s);
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        str.append("&quot;");
                        break;
                    }
                    case '&': {
                        str.append("&amp;");
                        break;
                    }
                    case '<': {
                        str.append("&lt;");
                        break;
                    }
                    case '>': {
                        str.append("&gt;");
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
                continue;
            }
            if (encodeSpecialChars && c < '\u00ff') {
                String hexChars = "0123456789ABCDEF";
                int a = c % 16;
                int b = (c - a) / 16;
                String hex = "" + hexChars.charAt(b) + hexChars.charAt(a);
                str.append("&#x").append(hex).append(";");
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }
}

