/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devrel.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class SandboxServlet
extends HttpServlet {
    private static final String WRM_REQUIRE_RESOURCE_KEY = "com.atlassian.plugins.atlassian-plugins-webresource-plugin:web-resource-manager";
    private final PageBuilderService pageBuilderService;
    private final WebResourceAssemblerFactory assemblerFactory;

    public SandboxServlet(WebResourceAssemblerFactory factory, PageBuilderService pageBuilderService) {
        this.assemblerFactory = factory;
        this.pageBuilderService = pageBuilderService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean includeSuperbatch = this.bool(req.getParameter("super"), false);
        boolean allowAsync = this.bool(req.getParameter("async"), false);
        List<String> contexts = this.safe(req.getParameterValues("context"));
        List<String> resources = this.safe(req.getParameterValues("resource"));
        if (allowAsync) {
            resources.add(WRM_REQUIRE_RESOURCE_KEY);
        }
        resp.setContentType("text/html;charset=UTF-8");
        resp.getWriter().write("<!doctype html><html><head>    <title>An empty page</title></head><body>    <p>You can use this page to test UI features in isolation!</p>    <p>Try the following things:</p>    <dl>        <dt>Load the superbatch</dt>        <dd><a href='?super=true'>Set <var>?super=true</var> in the URL</a></dd>        <dt>Load <var>WRM.require</var></dt>        <dd><a href='?async=true'>Set <var>?async=true</var> in the URL</a></dd>        <dt>Load a specific web-resource</dt>        <dd>Set <var>resource=[webresource-key]</var> in the URL</var></dd>        <dt>Load a specific web-resource context</dt>        <dd>Set <var>context=[webresource-key]</var> in the URL</var></dd>    </dl>");
        resp.getWriter().flush();
        WebResourceAssembler assembler = this.getAssembler(includeSuperbatch);
        for (String ctx : contexts) {
            assembler.resources().requireContext(ctx);
        }
        for (String res : resources) {
            assembler.resources().requireWebResource(res);
        }
        WebResourceSet webResourceSet = assembler.assembled().drainIncludedResources();
        StringWriter webResourceWriter = new StringWriter();
        webResourceSet.writeHtmlTags((Writer)webResourceWriter, UrlMode.AUTO);
        String webResourceHtml = ((Object)webResourceWriter).toString();
        if (webResourceHtml.length() > 0) {
            resp.getWriter().write(webResourceHtml);
            resp.getWriter().write("<p>The requested resources have been loaded!</p>");
        }
        if (allowAsync) {
            resp.getWriter().write("    <p>There should be a <code>WRM.require</code> function on the page now.</p>\n    <p>Try running something like:</p>\n    <pre><code>WRM.require(['com.atlassian.auiplugin:ajs'], function() {\n        console.log('loaded', {AJS});\n    })</code></pre>\n");
        }
        resp.getWriter().flush();
        resp.getWriter().write("</body></html>");
        resp.getWriter().close();
    }

    private WebResourceAssembler getAssembler(boolean includeSuperbatch) {
        if (null != this.assemblerFactory) {
            return this.assemblerFactory.create().includeSuperbatchResources(includeSuperbatch).build();
        }
        return this.pageBuilderService.assembler();
    }

    private boolean bool(String val, boolean defaultVal) {
        if (val == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(val);
    }

    private List<String> safe(String[] input) {
        ArrayList<String> results = new ArrayList<String>();
        if (input != null) {
            for (String val : input) {
                if (val == null || val.length() <= 0) continue;
                results.add(val);
            }
        }
        return results;
    }
}

