/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas.pullrequest;

import com.atlassian.devops.schemas.EntityAssociation;
import com.atlassian.devops.schemas.Payloadable;
import com.atlassian.devops.schemas.ProviderReference;
import com.atlassian.devops.schemas.RepositoryReference;
import com.atlassian.devops.schemas.TrackingReference;
import com.atlassian.devops.schemas.pullrequest.PullRequest;
import com.atlassian.devops.schemas.pullrequest.PullRequestCreated;
import com.atlassian.devops.schemas.pullrequest.PullRequestEvent;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestCreated", generator="Immutables")
@Immutable
public final class ImmutablePullRequestCreated
implements PullRequestCreated {
    @Nullable
    private final TrackingReference tracking;
    private final EntityAssociation associations;
    private final ProviderReference provider;
    private final RepositoryReference repository;
    private final PullRequest pullRequest;
    private final transient String metaType;
    private final transient String metaSchemaAri;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePullRequestCreated(@Nullable TrackingReference tracking, EntityAssociation associations, ProviderReference provider, RepositoryReference repository, PullRequest pullRequest) {
        this.tracking = tracking;
        this.associations = associations;
        this.provider = provider;
        this.repository = repository;
        this.pullRequest = pullRequest;
        this.metaType = this.initShim.metaType();
        this.metaSchemaAri = this.initShim.metaSchemaAri();
        this.initShim = null;
    }

    private String metaTypeInitialize() {
        return PullRequestCreated.super.metaType();
    }

    private String metaSchemaAriInitialize() {
        return PullRequestCreated.super.metaSchemaAri();
    }

    @Override
    @JsonProperty
    @Nullable
    public TrackingReference tracking() {
        return this.tracking;
    }

    @Override
    @JsonProperty
    public EntityAssociation associations() {
        return this.associations;
    }

    @Override
    @JsonProperty
    public ProviderReference provider() {
        return this.provider;
    }

    @Override
    @JsonProperty
    public RepositoryReference repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    public PullRequest pullRequest() {
        return this.pullRequest;
    }

    @Override
    @JsonProperty(value="metaType")
    public String metaType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metaType() : this.metaType;
    }

    @Override
    @JsonProperty(value="metaSchemaAri")
    public String metaSchemaAri() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metaSchemaAri() : this.metaSchemaAri;
    }

    public final ImmutablePullRequestCreated withTracking(@Nullable TrackingReference value) {
        if (this.tracking == value) {
            return this;
        }
        return new ImmutablePullRequestCreated(value, this.associations, this.provider, this.repository, this.pullRequest);
    }

    public final ImmutablePullRequestCreated withAssociations(EntityAssociation value) {
        if (this.associations == value) {
            return this;
        }
        EntityAssociation newValue = Objects.requireNonNull(value, "associations");
        return new ImmutablePullRequestCreated(this.tracking, newValue, this.provider, this.repository, this.pullRequest);
    }

    public final ImmutablePullRequestCreated withProvider(ProviderReference value) {
        if (this.provider == value) {
            return this;
        }
        ProviderReference newValue = Objects.requireNonNull(value, "provider");
        return new ImmutablePullRequestCreated(this.tracking, this.associations, newValue, this.repository, this.pullRequest);
    }

    public final ImmutablePullRequestCreated withRepository(RepositoryReference value) {
        if (this.repository == value) {
            return this;
        }
        RepositoryReference newValue = Objects.requireNonNull(value, "repository");
        return new ImmutablePullRequestCreated(this.tracking, this.associations, this.provider, newValue, this.pullRequest);
    }

    public final ImmutablePullRequestCreated withPullRequest(PullRequest value) {
        if (this.pullRequest == value) {
            return this;
        }
        PullRequest newValue = Objects.requireNonNull(value, "pullRequest");
        return new ImmutablePullRequestCreated(this.tracking, this.associations, this.provider, this.repository, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestCreated && this.equalTo((ImmutablePullRequestCreated)another);
    }

    private boolean equalTo(ImmutablePullRequestCreated another) {
        return Objects.equals(this.tracking, another.tracking) && this.associations.equals(another.associations) && this.provider.equals(another.provider) && this.repository.equals(another.repository) && this.pullRequest.equals(another.pullRequest) && this.metaType.equals(another.metaType) && this.metaSchemaAri.equals(another.metaSchemaAri);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tracking);
        h += (h << 5) + this.associations.hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.repository.hashCode();
        h += (h << 5) + this.pullRequest.hashCode();
        h += (h << 5) + this.metaType.hashCode();
        h += (h << 5) + this.metaSchemaAri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PullRequestCreated").omitNullValues().add("tracking", (Object)this.tracking).add("associations", (Object)this.associations).add("provider", (Object)this.provider).add("repository", (Object)this.repository).add("pullRequest", (Object)this.pullRequest).add("metaType", (Object)this.metaType).add("metaSchemaAri", (Object)this.metaSchemaAri).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestCreated fromJson(Json json) {
        Builder builder = ImmutablePullRequestCreated.builder();
        if (json.tracking != null) {
            builder.tracking(json.tracking);
        }
        if (json.associations != null) {
            builder.associations(json.associations);
        }
        if (json.provider != null) {
            builder.provider(json.provider);
        }
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.pullRequest != null) {
            builder.pullRequest(json.pullRequest);
        }
        return builder.build();
    }

    public static ImmutablePullRequestCreated copyOf(PullRequestCreated instance) {
        if (instance instanceof ImmutablePullRequestCreated) {
            return (ImmutablePullRequestCreated)instance;
        }
        return ImmutablePullRequestCreated.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestCreated", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ASSOCIATIONS = 1L;
        private static final long INIT_BIT_PROVIDER = 2L;
        private static final long INIT_BIT_REPOSITORY = 4L;
        private static final long INIT_BIT_PULL_REQUEST = 8L;
        private long initBits = 15L;
        @Nullable
        private TrackingReference tracking;
        @Nullable
        private EntityAssociation associations;
        @Nullable
        private ProviderReference provider;
        @Nullable
        private RepositoryReference repository;
        @Nullable
        private PullRequest pullRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Payloadable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestCreated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Payloadable instance;
            TrackingReference trackingValue;
            if (object instanceof Payloadable && (trackingValue = (instance = (Payloadable)object).tracking()) != null) {
                this.tracking(trackingValue);
            }
            if (object instanceof PullRequestEvent) {
                instance = (PullRequestEvent)object;
                this.associations(instance.associations());
                this.repository(instance.repository());
                this.provider(instance.provider());
                this.pullRequest(instance.pullRequest());
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tracking(@Nullable TrackingReference tracking) {
            this.tracking = tracking;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder associations(EntityAssociation associations) {
            this.associations = Objects.requireNonNull(associations, "associations");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder provider(ProviderReference provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(RepositoryReference repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequest(PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutablePullRequestCreated build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePullRequestCreated(this.tracking, this.associations, this.provider, this.repository, this.pullRequest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("associations");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("provider");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("repository");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("pullRequest");
            }
            return "Cannot build PullRequestCreated, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestCreated", generator="Immutables")
    static final class Json
    implements PullRequestCreated {
        @Nullable
        TrackingReference tracking;
        @Nullable
        EntityAssociation associations;
        @Nullable
        ProviderReference provider;
        @Nullable
        RepositoryReference repository;
        @Nullable
        PullRequest pullRequest;

        Json() {
        }

        @JsonProperty
        public void setTracking(@Nullable TrackingReference tracking) {
            this.tracking = tracking;
        }

        @JsonProperty
        public void setAssociations(EntityAssociation associations) {
            this.associations = associations;
        }

        @JsonProperty
        public void setProvider(ProviderReference provider) {
            this.provider = provider;
        }

        @JsonProperty
        public void setRepository(RepositoryReference repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setPullRequest(PullRequest pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public TrackingReference tracking() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EntityAssociation associations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProviderReference provider() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RepositoryReference repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequest pullRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String metaType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String metaSchemaAri() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="PullRequestCreated", generator="Immutables")
    private final class InitShim {
        private byte metaTypeBuildStage = 0;
        private String metaType;
        private byte metaSchemaAriBuildStage = 0;
        private String metaSchemaAri;

        private InitShim() {
        }

        String metaType() {
            if (this.metaTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metaTypeBuildStage == 0) {
                this.metaTypeBuildStage = (byte)-1;
                this.metaType = Objects.requireNonNull(ImmutablePullRequestCreated.this.metaTypeInitialize(), "metaType");
                this.metaTypeBuildStage = 1;
            }
            return this.metaType;
        }

        String metaSchemaAri() {
            if (this.metaSchemaAriBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metaSchemaAriBuildStage == 0) {
                this.metaSchemaAriBuildStage = (byte)-1;
                this.metaSchemaAri = Objects.requireNonNull(ImmutablePullRequestCreated.this.metaSchemaAriInitialize(), "metaSchemaAri");
                this.metaSchemaAriBuildStage = 1;
            }
            return this.metaSchemaAri;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.metaTypeBuildStage == -1) {
                attributes.add("metaType");
            }
            if (this.metaSchemaAriBuildStage == -1) {
                attributes.add("metaSchemaAri");
            }
            return "Cannot build PullRequestCreated, attribute initializers form cycle " + attributes;
        }
    }
}

