/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.RepositoryReference;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryReference", generator="Immutables")
@Immutable
public final class ImmutableRepositoryReference
implements RepositoryReference {
    private final String id;
    private final String name;
    private final URI url;

    private ImmutableRepositoryReference(String id, String name, URI url) {
        this.id = id;
        this.name = name;
        this.url = url;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public URI url() {
        return this.url;
    }

    public final ImmutableRepositoryReference withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryReference(newValue, this.name, this.url);
    }

    public final ImmutableRepositoryReference withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryReference(this.id, newValue, this.url);
    }

    public final ImmutableRepositoryReference withUrl(URI value) {
        if (this.url == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "url");
        return new ImmutableRepositoryReference(this.id, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryReference && this.equalTo((ImmutableRepositoryReference)another);
    }

    private boolean equalTo(ImmutableRepositoryReference another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RepositoryReference").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("url", (Object)this.url).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryReference fromJson(Json json) {
        Builder builder = (Builder)ImmutableRepositoryReference.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static ImmutableRepositoryReference copyOf(RepositoryReference instance) {
        if (instance instanceof ImmutableRepositoryReference) {
            return (ImmutableRepositoryReference)instance;
        }
        return ((Builder)ImmutableRepositoryReference.builder()).id(instance.id()).name(instance.name()).url(instance.url()).build();
    }

    public static IdBuildStage builder() {
        return new Builder();
    }

    @Generated(from="RepositoryReference", generator="Immutables")
    public static interface BuildFinal {
        public ImmutableRepositoryReference build();
    }

    @Generated(from="RepositoryReference", generator="Immutables")
    public static interface UrlBuildStage {
        public BuildFinal url(URI var1);
    }

    @Generated(from="RepositoryReference", generator="Immutables")
    public static interface NameBuildStage {
        public UrlBuildStage name(String var1);
    }

    @Generated(from="RepositoryReference", generator="Immutables")
    public static interface IdBuildStage {
        public NameBuildStage id(String var1);
    }

    @Generated(from="RepositoryReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements IdBuildStage,
    NameBuildStage,
    UrlBuildStage,
    BuildFinal {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_URL = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private URI url;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(URI url) {
            Builder.checkNotIsSet(this.urlIsSet(), "url");
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableRepositoryReference build() {
            this.checkRequiredAttributes();
            return new ImmutableRepositoryReference(this.id, this.name, this.url);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RepositoryReference is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            return "Cannot build RepositoryReference, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepositoryReference", generator="Immutables")
    static final class Json
    implements RepositoryReference {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        URI url;

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setUrl(URI url) {
            this.url = url;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }
    }
}

