package com.atlassian.db.config.password.ciphers.algorithm.serialization;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationFile {
    private static final Logger log = LoggerFactory.getLogger(SerializationFile.class);
    private final String notEmptyFilePath;

    public SerializationFile(final String notEmptyFilePath) {
        this.notEmptyFilePath = notEmptyFilePath;
    }

    public <T> void createFileAndSave(final T objectToSave) {
        try (final ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(notEmptyFilePath))) {
            objectOutputStream.writeObject(objectToSave);
            log.debug("Saved file: " + notEmptyFilePath);
        } catch (final IOException e) {
            log.error("Couldn't save or create file needed for encryption/decryption. Tried to save object: {} using file path: {}", objectToSave, notEmptyFilePath, e);
            throw new RuntimeException(e);
        }
    }

    public <T> T read(final Class<T> clazz) {
        try (final ObjectInputStream objectIn = new ObjectInputStream(new FileInputStream(notEmptyFilePath))) {
            final T o = (T) objectIn.readObject();
            if (!o.getClass().getCanonicalName().equals(clazz.getCanonicalName())) {
                throw new ClassCastException("Expected: " + clazz + ", got: " + o.getClass());
            }
            return o;
        } catch (final IOException e) {
            log.error("Couldn't read file needed for encryption/decryption. Tried to read file under: " + notEmptyFilePath, e);
            throw new RuntimeException(e);
        } catch (final ClassCastException e) {
            log.error("Couldn't cast object found under: " + notEmptyFilePath + " Make sure you are passing correct file path.", e);
            throw new RuntimeException(e);
        } catch (final ClassNotFoundException e) {
            log.error("Couldn't find class for object found under: " + notEmptyFilePath + " Make sure you are passing correct file path.", e);
            throw new RuntimeException(e);
        }
    }
}
