/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.db.config.password.ciphers.algorithm.paramters;

public class EncryptionParameters {
    private final String plainTextPassword;
    private final String algorithm;
    private final String algorithmKey;
    private final String algorithmParametersFilePath;
    private final String keyFilePath;

    public EncryptionParameters(String plainTextPassword, String algorithm, String algorithmKey, String algorithmParametersFilePath, String keyFilePath) {
        this.plainTextPassword = plainTextPassword;
        this.algorithm = algorithm;
        this.algorithmKey = algorithmKey;
        this.algorithmParametersFilePath = algorithmParametersFilePath;
        this.keyFilePath = keyFilePath;
    }

    public String getPlainTextPassword() {
        return this.plainTextPassword;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmKey() {
        return this.algorithmKey;
    }

    public String getAlgorithmParametersFilePath() {
        return this.algorithmParametersFilePath;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public String toString() {
        return "EncryptionParameters{plainTextPassword='<SANITIZED>', algorithm='" + this.algorithm + '\'' + ", algorithmKey='" + this.algorithmKey + '\'' + ", algorithmParametersFilePath='" + this.algorithmParametersFilePath + '\'' + ", keyFilePath='" + this.keyFilePath + '\'' + '}';
    }

    public static class Builder {
        private String plainTextPassword;
        private String algorithm;
        private String algorithmKey;
        private String algorithmParametersFilePath;
        private String keyFilePath;

        public Builder setPlainTextPassword(String plainTextPassword) {
            this.plainTextPassword = plainTextPassword;
            return this;
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder setAlgorithmKey(String algorithmKey) {
            this.algorithmKey = algorithmKey;
            return this;
        }

        public Builder setAlgorithmParametersFilePath(String algorithmParametersFilePath) {
            this.algorithmParametersFilePath = algorithmParametersFilePath;
            return this;
        }

        public Builder setKeyFilePath(String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        public EncryptionParameters build() {
            return new EncryptionParameters(this.plainTextPassword, this.algorithm, this.algorithmKey, this.algorithmParametersFilePath, this.keyFilePath);
        }
    }
}

