/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.db.config.password.ciphers.algorithm;

import com.atlassian.db.config.password.Cipher;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.DecryptionParameters;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.EncryptionParameters;
import com.atlassian.db.config.password.ciphers.algorithm.serialization.EnvironmentVarBasedConfiguration;
import com.atlassian.db.config.password.ciphers.algorithm.serialization.SerializationFileFactory;
import com.atlassian.db.config.password.ciphers.algorithm.serialization.UniqueFilePathGenerator;
import com.google.gson.Gson;
import java.io.Serializable;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.time.Clock;
import java.util.Optional;
import java.util.function.Function;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmCipher
implements Cipher {
    private static final Logger log = LoggerFactory.getLogger(AlgorithmCipher.class);
    private final Provider provider = new BouncyCastleProvider();
    private final Gson gson = new Gson();
    private final SerializationFileFactory factory;
    private Clock clock = Clock.systemUTC();
    private Function<String, String> getSystemEnv = System::getenv;

    public AlgorithmCipher() {
        log.debug("Initiate AlgorithmCipher");
        Security.addProvider(this.provider);
        this.factory = new SerializationFileFactory();
    }

    AlgorithmCipher(SerializationFileFactory factory, Clock clock, Function<String, String> getSystemEnv) {
        this.factory = factory;
        this.clock = clock;
        this.getSystemEnv = getSystemEnv;
    }

    public String encrypt(String encryptionParamsInJson) {
        log.debug("Encrypting data...");
        String encrypted = this.gson.toJson((Object)this.encrypt((EncryptionParameters)this.gson.fromJson(encryptionParamsInJson, EncryptionParameters.class)));
        log.debug("Encryption done.");
        return encrypted;
    }

    public String decrypt(String decryptionParamsInJson) {
        log.debug("Decrypting data...");
        String decrypted = this.decrypt((DecryptionParameters)this.gson.fromJson(decryptionParamsInJson, DecryptionParameters.class)).getPlainTextPassword();
        log.debug("Decryption done.");
        return decrypted;
    }

    private EncryptionParameters decrypt(DecryptionParameters dataToDecrypt) {
        try {
            String encryptedPassFilePath = this.tryFromParamsThenEnvThenThrow(dataToDecrypt.getSealedObjectFilePath(), SealedObject.class.getName());
            SealedObject encryptedPass = this.factory.getSerializationFile(encryptedPassFilePath).read(SealedObject.class);
            String keyFilePath = this.tryFromParamsThenEnvThenThrow(dataToDecrypt.getKeyFilePath(), SecretKeySpec.class.getName());
            String plainTextPassword = (String)encryptedPass.getObject(this.factory.getSerializationFile(keyFilePath).read(SecretKeySpec.class));
            return new EncryptionParameters.Builder().setPlainTextPassword(plainTextPassword).build();
        }
        catch (Exception e) {
            log.error("Runtime Exception thrown when decrypting: " + dataToDecrypt, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private DecryptionParameters encrypt(EncryptionParameters parameters) {
        try {
            SecretKeySpec key;
            String keyPath;
            AlgorithmParameters algorithmParameters;
            String algParamsPath;
            String string = algParamsPath = parameters.getAlgorithmParametersFilePath() == null ? this.getFromEnv(AlgorithmParameters.class.getName()) : parameters.getAlgorithmParametersFilePath();
            if (algParamsPath == null) {
                algParamsPath = this.generateFilePath(AlgorithmParameters.class.getName());
                algorithmParameters = this.generateAlgorithmParameters(parameters.getAlgorithmKey());
                this.factory.getAlgorithmParametersSerializationFile(algParamsPath).createFileAndSave(algorithmParameters);
                log.debug("Name of generated file with algorithm params used for encryption: " + algParamsPath);
            } else {
                algorithmParameters = this.factory.getAlgorithmParametersSerializationFile(algParamsPath).read(parameters.getAlgorithmKey());
            }
            String string2 = keyPath = parameters.getKeyFilePath() == null ? this.getFromEnv(SecretKeySpec.class.getName()) : parameters.getKeyFilePath();
            if (keyPath == null) {
                key = this.generateSecretKey(parameters.getAlgorithmKey());
                keyPath = this.generateFilePath(SecretKeySpec.class.getName());
                this.factory.getSerializationFile(keyPath).createFileAndSave(key);
            } else {
                key = this.factory.getSerializationFile(keyPath).read(SecretKeySpec.class);
            }
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(parameters.getAlgorithm(), this.provider);
            cipher.init(1, (Key)key, algorithmParameters);
            SealedObject encryptedPass = new SealedObject((Serializable)((Object)parameters.getPlainTextPassword()), cipher);
            String pathToSealedObject = this.generateFilePath(encryptedPass.getClass().getName());
            this.factory.getSerializationFile(pathToSealedObject).createFileAndSave(encryptedPass);
            return new DecryptionParameters.Builder().setSealedObjectFilePath(pathToSealedObject).setKeyFilePath(keyPath).build();
        }
        catch (Exception e) {
            log.error("Exception thrown when encrypting: " + parameters, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private SecretKeySpec generateSecretKey(String algorithmKey) {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(algorithmKey, this.provider);
            keyGen.init(this.getKeySize(algorithmKey));
            return (SecretKeySpec)keyGen.generateKey();
        }
        catch (Exception e) {
            log.error("Exception thrown when generating key for algorithm: " + algorithmKey, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private AlgorithmParameters generateAlgorithmParameters(String algorithmKey) {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(algorithmKey, this.provider);
            algorithmParameterGenerator.init(new SecureRandom().nextInt(), new SecureRandom());
            return algorithmParameterGenerator.generateParameters();
        }
        catch (Exception e) {
            log.error("Exception thrown when generating algorithm parameters for algorithm: " + algorithmKey, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private int getKeySize(String algorithmKey) {
        switch (algorithmKey) {
            case "AES": {
                return 128;
            }
            case "DES": {
                return 56;
            }
            case "DESede": {
                return 168;
            }
        }
        return 24;
    }

    private String getFromEnv(String objectClassName) {
        EnvironmentVarBasedConfiguration environmentVarBasedConfiguration = new EnvironmentVarBasedConfiguration(objectClassName, this.getSystemEnv);
        return environmentVarBasedConfiguration.getFromEnv();
    }

    private String generateFilePath(String objectClassName) {
        return new UniqueFilePathGenerator(objectClassName, this.clock).generateName();
    }

    private String tryFromParamsThenEnvThenThrow(String filePathFromParams, String objectClassName) {
        return Optional.ofNullable(filePathFromParams).orElseGet(() -> Optional.ofNullable(this.getFromEnv(objectClassName)).orElseThrow(() -> new IllegalArgumentException("Missing file path for: " + objectClassName)));
    }
}

