package com.atlassian.db.config.password.ciphers.algorithm.serialization;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.Clock;

public class UniqueFilePathGenerator {
    private final Clock clock;
    private final String objectClassName;

    private static final Logger log = LoggerFactory.getLogger(UniqueFilePathGenerator.class);

    public UniqueFilePathGenerator(final String objectClassName, final Clock clock) {
        this.objectClassName = objectClassName;
        this.clock = clock;
    }

    public String generateName() {
        final String nonEmptyPath = objectClassName + "_" + clock.instant().toEpochMilli();
        log.debug("Will use generated name: " + nonEmptyPath);
        return nonEmptyPath;
    }
}