package com.atlassian.db.config.password.ciphers.algorithm.serialization;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;

public class AlgorithmParametersSerializationFile {

    private static final Logger log = LoggerFactory.getLogger(AlgorithmParametersSerializationFile.class);

    private final String notEmptyFilePath;

    public AlgorithmParametersSerializationFile(final String notEmptyFilePath) {
        this.notEmptyFilePath = notEmptyFilePath;
    }

    public void createFileAndSave(final AlgorithmParameters objectToSave) {
        try (final FileOutputStream fileOutputStream = new FileOutputStream(notEmptyFilePath)) {
            fileOutputStream.write(objectToSave.getEncoded());
        } catch (final IOException e) {
            log.error("Couldn't save or create file needed for encryption/decryption. Tried to save object: {} using file path: {}", objectToSave, notEmptyFilePath, e);
            throw new RuntimeException(e);
        }
    }

    public AlgorithmParameters read(final String algorithm) {
        try {
            final AlgorithmParameters parameters = AlgorithmParameters.getInstance(algorithm);
            parameters.init(Files.readAllBytes(new File(notEmptyFilePath).toPath()));
            return parameters;
        } catch (final IOException e) {
            log.error("Couldn't read file needed for encryption/decryption. Tried to read file under: " + notEmptyFilePath, e);
            throw new RuntimeException(e);
        } catch (final NoSuchAlgorithmException e) {
            log.error("Wrong algorithm key passed:" + algorithm);
            throw new RuntimeException(e);
        }
    }
}
