package com.atlassian.db.config.password.ciphers.algorithm.paramters;

public class EncryptionParameters {

    private final String plainTextPassword;
    private final String algorithm;
    private final String algorithmKey;

    //Optionals
    private final String algorithmParametersFilePath;
    private final String keyFilePath;

    public EncryptionParameters(final String plainTextPassword, final String algorithm, final String algorithmKey, final String algorithmParametersFilePath, final String keyFilePath) {
        this.plainTextPassword = plainTextPassword;
        this.algorithm = algorithm;
        this.algorithmKey = algorithmKey;
        this.algorithmParametersFilePath = algorithmParametersFilePath;
        this.keyFilePath = keyFilePath;
    }

    public String getPlainTextPassword() {
        return plainTextPassword;
    }

    public String getAlgorithm() {
        return algorithm;
    }

    public String getAlgorithmKey() {
        return algorithmKey;
    }

    public String getAlgorithmParametersFilePath() {
        return algorithmParametersFilePath;
    }

    public String getKeyFilePath() {
        return keyFilePath;
    }

    public static class Builder {
        private String plainTextPassword;
        private String algorithm;
        private String algorithmKey;
        private String algorithmParametersFilePath;
        private String keyFilePath;

        public Builder setPlainTextPassword(final String plainTextPassword) {
            this.plainTextPassword = plainTextPassword;
            return this;
        }

        public Builder setAlgorithm(final String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder setAlgorithmKey(final String algorithmKey) {
            this.algorithmKey = algorithmKey;
            return this;
        }

        public Builder setAlgorithmParametersFilePath(final String algorithmParametersFilePath) {
            this.algorithmParametersFilePath = algorithmParametersFilePath;
            return this;
        }

        public Builder setKeyFilePath(final String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        public EncryptionParameters build() {
            return new EncryptionParameters(plainTextPassword, algorithm, algorithmKey, algorithmParametersFilePath, keyFilePath);
        }
    }

    @Override
    public String toString() {
        return "EncryptionParameters{" +
                "plainTextPassword='<SANITIZED>'"+
                ", algorithm='" + algorithm + '\'' +
                ", algorithmKey='" + algorithmKey + '\'' +
                ", algorithmParametersFilePath='" + algorithmParametersFilePath + '\'' +
                ", keyFilePath='" + keyFilePath + '\'' +
                '}';
    }
}
